package gov.cms.grouper.snf.model;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.cms.grouper.snf.SnfOption;
import gov.cms.grouper.snf.SnfRuntimeOption;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import java.io.IOException;

/**
 * This is the base component structure that the versioned components. This class and its extended
 * classes should ensure that the 'scoring' is thread safe and be configurable with a minimal of
 * outside setup.
 */
public abstract class SnfComponentAbstract
    implements Processable<ISnfClaim, SnfOption, SnfRuntimeOption> {

  /**
   * This checks for a valid claim and if valid, then scores the claim.
   *
   * @param claim non-null SnfClaim.
   *
   * @throws FoundationException rarely would happen
   */
  @Override
  public void process(ISnfClaim claim) throws FoundationException {
    // Validate claim information
    SnfError validationError = this.validates(claim);

    if (validationError == null) {
      this.exec(claim);

    } else {
      claim.addErrors(validationError.getReason());
    }

  }

  public abstract void exec(ISnfClaim claim);

  /**
   * Validates the claim using Rai300 enums.
   *
   * @param claim non-null claim.
   *
   * @return non-null Error
   */
  public abstract SnfError validates(ISnfClaim claim);

  @Override
  public void close() throws IOException {
    // TODO Auto-generated method stub

  }

  /**
   * not used
   */
  @Override
  public void reconfigure(SnfRuntimeOption option) throws FoundationException {

  }

}
